---
layout: page
title: Dependencies & Plugins
---
#### Dependencies
AdminLTE depends on two main frameworks. The downloadable package contains both of these libraries, so you don't have to manually download them.
{: .lead}

- [Bootstrap 4](https://getbootstrap.com)
- [jQuery 3.3.1+](https://jquery.com/)
- [Popper.js 1.14.7+](https://popper.js.org/)
- [All other plugins are listed below](#plugins)

<a id="plugins" class="anchor"></a>
#### Plugins
{: .mt-4 .anchor}

AdminLTE makes use of the following plugins. For documentation, updates or license information, please visit the provided links.
{: .lead}

> Note!
> You need to load the js/css files of the plugin that you want to use.
> AdminLTE doesn't load automatically all plugins, this would cause huge load times on every page load.
{:.quote-warning}

<div class="row px-3">
  <div class="col-sm-3">
    <ul class="list-unstyled">
      <li><h4>Charts</h4></li>
      <li><a href="http://www.chartjs.org/" target="_blank">ChartJS</a></li>
      <li><a href="http://www.flotcharts.org/" target="_blank">Flot</a></li>
      <li><a href="https://github.com/mariusGundersen/sparkline" target="_blank">Sparkline</a></li>
    </ul>
  </div>
  <div class="col-sm-3">
    <ul class="list-unstyled">
      <li><h4>Editors</h4></li>
      <li><a href="https://summernote.org/" target="_blank">Summernote</a></li>
    </ul>
  </div>
  <div class="col-sm-3">
    <ul class="list-unstyled">
      <li><h4>Form Elements</h4></li>
      <li><a href="https://farbelous.io/bootstrap-colorpicker/">Bootstrap Colorpicker</a></li>
      <li><a href="https://github.com/seiyria/bootstrap-slider/">Bootstrap Slider</a></li>
      <li><a href="http://www.daterangepicker.com/" target="_blank">Date Range Picker</a></li>
      <li><a href="https://github.com/bantikyan/icheck-bootstrap#readme" target="_blank">iCheck Bootstrap</a></li>
      <li><a href="https://github.com/RobinHerbots/Inputmask/" target="_blank">Inputmask</a></li>
      <li><a href="http://ionden.com/a/plugins/ion.rangeSlider/" target="_blank">Ion.RangeSlider</a></li>
      <li><a href="https://select2.org/" target="_blank">Select2</a></li>
      <li><a href="https://tempusdominus.github.io/bootstrap-4/" target="_blank">Tempus Dominus</a></li>
      <li><a href="https://github.com/istvan-ujjmeszaros/bootstrap-duallistbox#readme" target="_blank">Bootstrap4 Duallistbox</a></li>
      <li><a href="https://github.com/Johann-S/bs-custom-file-input#readme" target="_blank">bs-custom-file-input</a></li>
    </ul>
  </div>
  <div class="col-sm-3">
    <ul class="list-unstyled">
      <li><h4>Icon Packs</h4></li>
      <li><a href="https://fontawesome.com/" target="_blank">FontAwesome 5</a></li>
      <li><a href="https://github.com/lipis/flag-icon-css#readme" target="_blank">flag-icon-css</a></li>
    </ul>
  </div>
</div>
<div class="row px-3">
  <div class="col-sm-3">
    <ul class="list-unstyled">
      <li><h4>Table Grids</h4></li>
      <li><a href="https://datatables.net/" target="_blank">DataTables</a></li>
      <li><a href="http://js-grid.com/" target="_blank">jsGrid</a></li>
    </ul>
  </div>
  <div class="col-sm-3">
    <ul class="list-unstyled">
      <li><h4>Notifications</h4></li>
      <li><a href="https://sweetalert2.github.io/" target="_blank">SweetAlert2</a></li>
      <li><a href="https://codeseven.github.io/toastr/" target="_blank">Toastr</a></li>
    </ul>
  </div>
  <div class="col-sm-3">
    <ul class="list-unstyled">
      <li><h4>Others</h4></li>
      <li><a href="https://github.com/ftlabs/fastclick#readme" target="_blank">FastClick</a></li>
      <li><a href="https://fullcalendar.io/">FullCalendar 4</a></li>
      <li><a href="https://github.com/aterrien/jQuery-Knob#readme">jQuery Knob</a></li>
      <li><a href="https://jqueryui.com/" target="_blank">jQuery UI</a></li>
      <li><a href="https://jqueryvalidation.org/" target="_blank">jQuery Validation</a></li>
      <li><a href="https://www.vincentbroute.fr/mapael/" target="_blank">jQuery Mapael</a></li>
      <li><a href="https://github.com/bbmumford/jqvmap#readme" target="_blank">jQuery Vector Map</a></li>
      <li><a href="https://kingsora.github.io/OverlayScrollbars/" target="_blank">Overlay Scrollbars</a></li>
      <li><a href="https://github.com/lgaitan/pace#readme" target="_blank">Pace Progress</a></li>
      <li><a href="https://github.com/giotiskl/filterizr#readme" target="_blank">FilterizR</a></li>
    </ul>
  </div>
  <div class="col-sm-3">
    <ul class="list-unstyled">
      <li><h4>Plugin Dependencies</h4></li>
      <li><a href="https://github.com/jquery/jquery-mousewheel#readme" target="_blank">jQuery Mousewheel</a></li>
      <li><a href="https://momentjs.com/" target="_blank">Moment.js</a></li>
      <li><a href="https://dmitrybaranovskiy.github.io/raphael/" target="_blank">Raphaël</a></li>
      <li><a href="https://github.com/bpampuch/pdfmake#readme" target="_blank">pdfmake</a></li>
      <li><a href="https://github.com/Stuk/jszip#readme" target="_blank">jszip</a></li>
    </ul>
  </div>
</div>
